"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const userRoutes_1 = __importDefault(require("./userRoutes"));
const authRoutes_1 = __importDefault(require("./authRoutes"));
const settingRoutes_1 = __importDefault(require("./settingRoutes"));
const contactRoutes_1 = __importDefault(require("./contactRoutes"));
const ticketRoutes_1 = __importDefault(require("./ticketRoutes"));
const whatsappRoutes_1 = __importDefault(require("./whatsappRoutes"));
const messageRoutes_1 = __importDefault(require("./messageRoutes"));
const whatsappSessionRoutes_1 = __importDefault(require("./whatsappSessionRoutes"));
const queueRoutes_1 = __importDefault(require("./queueRoutes"));
const quickAnswerRoutes_1 = __importDefault(require("./quickAnswerRoutes"));
const apiRoutes_1 = __importDefault(require("./apiRoutes"));
const routes = express_1.Router();
routes.use(userRoutes_1.default);
routes.use("/auth", authRoutes_1.default);
routes.use(settingRoutes_1.default);
routes.use(contactRoutes_1.default);
routes.use(ticketRoutes_1.default);
routes.use(whatsappRoutes_1.default);
routes.use(messageRoutes_1.default);
routes.use(whatsappSessionRoutes_1.default);
routes.use(queueRoutes_1.default);
routes.use(quickAnswerRoutes_1.default);
routes.use("/api/messages", apiRoutes_1.default);
exports.default = routes;
